import random
import subprocess
import platform

# назначаю цвета для надписей
RESET = "\033[0m"      # Сброс цвета
RED = "\033[91m"       # Красный
GREEN = "\033[92m"     # Зеленый
YELLOW = "\033[93m"    # Желтый


# глобальные настройки игры
_from = 0  # от числа
_till = 10 # до числа
_tries = 20 # количество попыток я вынесу в настройки для удобства изменения
_secret = 0 # я сделал _secret глабольной переменной (потом объясню, кому интересно)

def ClearScreen():
    command = 'cls' if platform.system() == 'Windows' else 'clear'
    subprocess.run(command, shell=True)

# функция для опеределения окончания слова ПОПЫТКА, ПОПЫТКИ, ПОПЫТОК в зависимости от числа
def GetEnding(number):
    # проверяю исключения: 11 попытОК, хотя 1 - попытка.
    if (number >= 11 and number <= 14):
        return "ок"
    
    # если не исключение проверяем по последней цифер в числе
    lastDigit = number % 10    
    if(lastDigit == 1):
        return "ка"    
    elif (lastDigit >= 2 and lastDigit <= 4):
        return "ки"
    else:
        return "ок"

while True:
    # вывод меню
    ClearScreen()
    print("="*57)    
    print("||" + " "*14 + f"{GREEN}Угадай число! Версия 2.0{RESET}" + " "*14 + "||") # Включем зелёный, пишем, сбрасываем на обычный
    print("="*57)
    print("Выберите режим игры:")
    print("-"*57)
    print("1 - Одиночная игра")
    print("2 - Парная игра")
    print("3 - Выход из игры")
    print("-"*57)

    # выбор режима игры
    menuChoice = input("Выберите вариант меню: ")

    # т.к. режимы игры отличаются только методом загадывания, то я не буду повторять код, 
    # а объединю два методоа игры в один блок кода, но буду выбирать метод загадывания через if
    
    if(menuChoice == "1" or menuChoice == "2"):
        ClearScreen()

        if(menuChoice == "1"):
            _secret = random.randint(_from, _till)
        else:
            while True:
                _secret = int(input("Игрок 1, Загадывай число от 0 до 10:"))
                if(_secret >= _from and _secret <= _till):                
                    break
                else:
                    print(f"Ты загадал неверное число! Оно лежит вне диапазона от {_from} до {_till}! Перезагадай!")
            

        lives = _tries
        ClearScreen()
        print("Число загадано! Отгадывайте!")
        print(f"{GREEN}У вас осталось {lives} попыт{GetEnding(lives)} из {_tries}!{RESET}")
        
        for i in range(1,lives+1):
            ans = int(input(f"Введите число от {_from} до {_till}: "))
            if(ans == _secret):
                print(f"{GREEN}Вы угадали!!! Молодец!{RESET}")
                break
            else:
                lives -= 1
                if(lives > 0):          
                    # Выбираем цвет надписи про оставшиесы попытки: меньше половины - жёлтый, меньше четверти - красный          
                    if lives < _tries/4:
                        COLOR = RED
                    elif lives < _tries/2:
                        COLOR = YELLOW                    
                    else:
                        COLOR = RESET

                    print(f"{COLOR}Неверно! У вас осталось {lives} попыт{GetEnding(lives)} из {_tries}{RESET}")
                else:
                    print(f"{RED}Вы проиграли! Аха-ха-ха-ха! \r\nЗагаданное число было: {_secret}{RESET}")
        
        rep = input("Сыграем ещё раз? Введите y или n: ")
        if(rep == "n"):
            break
    elif menuChoice == "3":
        print("Спасибо за игру, приходи ещё! Пока!")
        break

            



